/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="advancedperipherals")
public class ChunkManager
extends SavedData {
    private static final String DATA_NAME = "advancedperipherals_ForcedChunks";
    private static final String FORCED_CHUNKS_TAG = "forcedChunks";
    private static int tickCounter = 0;
    private final Map<UUID, LoadChunkRecord> forcedChunks = new HashMap<UUID, LoadChunkRecord>();
    private boolean initialized = false;

    @NotNull
    public static ChunkManager get(@NotNull ServerLevel level) {
        return (ChunkManager)level.m_8895_().m_164861_(ChunkManager::load, ChunkManager::new, DATA_NAME);
    }

    public static ChunkManager load(@NotNull CompoundTag data) {
        ChunkManager manager = new ChunkManager();
        CompoundTag forcedData = data.m_128469_(FORCED_CHUNKS_TAG);
        for (String key : forcedData.m_128431_()) {
            manager.forcedChunks.put(UUID.fromString(key), LoadChunkRecord.deserialize(forcedData.m_128469_(key)));
        }
        return manager;
    }

    @SubscribeEvent
    public static void beforeServerStopped(ServerStoppingEvent event) {
        ChunkManager.get(event.getServer().m_129783_()).stop();
    }

    @SubscribeEvent
    public static void afterServerStarted(ServerStartedEvent event) {
        ChunkManager.get(event.getServer().m_129783_()).init();
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++tickCounter % ((Integer)APConfig.PERIPHERALS_CONFIG.chunkLoadValidTime.get() / 2) == 0) {
            ChunkManager.get(ServerLifecycleHooks.getCurrentServer().m_129783_()).cleanup();
        }
    }

    public synchronized boolean addForceChunk(ServerLevel level, UUID owner, ChunkPos pos) {
        AdvancedPeripherals.debug("Trying to load forced chunk " + pos, Level.WARN);
        if (this.forcedChunks.containsKey(owner)) {
            return true;
        }
        this.forcedChunks.put(owner, new LoadChunkRecord(level.m_46472_().m_135782_().toString(), pos));
        this.m_77762_();
        return ForgeChunkManager.forceChunk((ServerLevel)level, (String)"advancedperipherals", (UUID)owner, (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)true);
    }

    public synchronized void touch(UUID owner) {
        if (this.forcedChunks.containsKey(owner)) {
            this.forcedChunks.get(owner).touch();
        }
    }

    public synchronized boolean removeForceChunk(ServerLevel level, UUID owner, ChunkPos pos) {
        AdvancedPeripherals.debug("Trying to unload forced chunk " + pos, Level.WARN);
        if (!this.forcedChunks.containsKey(owner)) {
            return true;
        }
        LoadChunkRecord chunkRecord = this.forcedChunks.get(owner);
        String dimensionName = level.m_46472_().m_135782_().toString();
        if (!chunkRecord.getDimensionName().equals(dimensionName)) {
            throw new IllegalArgumentException(String.format("Incorrect dimension! Should be %s instead of %s", chunkRecord.getDimensionName(), dimensionName));
        }
        boolean result = ForgeChunkManager.forceChunk((ServerLevel)level, (String)"advancedperipherals", (UUID)owner, (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)true);
        if (result) {
            this.forcedChunks.remove(owner);
            this.m_77762_();
        }
        return result;
    }

    public synchronized void init() {
        if (!this.initialized) {
            AdvancedPeripherals.debug("Schedule chunk manager init", Level.WARN);
            ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(level -> {
                String dimensionName = level.m_46472_().m_135782_().toString();
                this.forcedChunks.entrySet().stream().filter(entry -> ((LoadChunkRecord)entry.getValue()).getDimensionName().equals(dimensionName)).forEach(entry -> ForgeChunkManager.forceChunk((ServerLevel)level, (String)"advancedperipherals", (UUID)((UUID)entry.getKey()), (int)((LoadChunkRecord)entry.getValue()).getPos().f_45578_, (int)((LoadChunkRecord)entry.getValue()).getPos().f_45579_, (boolean)true, (boolean)true));
            });
            this.initialized = true;
        }
    }

    public synchronized void stop() {
        if (this.initialized) {
            AdvancedPeripherals.debug("Schedule chunk manager stop", Level.WARN);
            ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(level -> {
                String dimensionName = level.m_46472_().m_135782_().toString();
                this.forcedChunks.entrySet().stream().filter(entry -> ((LoadChunkRecord)entry.getValue()).getDimensionName().equals(dimensionName)).forEach(entry -> ForgeChunkManager.forceChunk((ServerLevel)level, (String)"advancedperipherals", (UUID)((UUID)entry.getKey()), (int)((LoadChunkRecord)entry.getValue()).getPos().f_45578_, (int)((LoadChunkRecord)entry.getValue()).getPos().f_45579_, (boolean)false, (boolean)true));
            });
            this.initialized = false;
        }
    }

    public synchronized void cleanup() {
        AdvancedPeripherals.debug("Schedule chunk manager cleanup", Level.WARN);
        ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(level -> {
            String dimensionName = level.m_46472_().m_135782_().toString();
            ArrayList purgeList = new ArrayList();
            this.forcedChunks.entrySet().stream().filter(entry -> ((LoadChunkRecord)entry.getValue()).getDimensionName().equals(dimensionName) && !((LoadChunkRecord)entry.getValue()).isValid()).forEach(entry -> purgeList.add((UUID)entry.getKey()));
            purgeList.forEach(uuid -> {
                AdvancedPeripherals.debug(String.format("Purge forced chunk for %s", uuid), Level.WARN);
                this.removeForceChunk((ServerLevel)level, (UUID)uuid, this.forcedChunks.get(uuid).getPos());
            });
        });
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag data) {
        CompoundTag forcedChunksTag = new CompoundTag();
        this.forcedChunks.forEach((key, value) -> forcedChunksTag.m_128365_(key.toString(), (Tag)value.serialize()));
        return data;
    }

    private static class LoadChunkRecord {
        private static final String POS_TAG = "pos";
        private static final String DIMENSION_NAME_TAG = "dimensionName";
        @NotNull
        private final String dimensionName;
        @NotNull
        private final ChunkPos pos;
        private long lastTouch;

        LoadChunkRecord(@NotNull String dimensionName, @NotNull ChunkPos pos) {
            this.dimensionName = dimensionName;
            this.pos = pos;
            this.lastTouch = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
        }

        public static LoadChunkRecord deserialize(@NotNull CompoundTag tag) {
            return new LoadChunkRecord(tag.m_128461_(DIMENSION_NAME_TAG), NBTUtil.chunkPosFromNBT(tag.m_128469_(POS_TAG)));
        }

        @NotNull
        public ChunkPos getPos() {
            return this.pos;
        }

        @NotNull
        public String getDimensionName() {
            return this.dimensionName;
        }

        public void touch() {
            this.lastTouch = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
        }

        public boolean isValid() {
            long currentEpoch = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
            return this.lastTouch + (long)((Integer)APConfig.PERIPHERALS_CONFIG.chunkLoadValidTime.get()).intValue() >= currentEpoch;
        }

        @NotNull
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(DIMENSION_NAME_TAG, this.dimensionName);
            tag.m_128365_(POS_TAG, (Tag)NBTUtil.toNBT(this.pos));
            return tag;
        }
    }
}

